using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgTransfusionEffectivenessReportCriteria
	/// </summary>
	public class DlgTransfusionEffectivenessReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.TransfusionEffectivenessReport _report;
		//
		private System.Windows.Forms.GroupBox grpReportType;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpPatient;
		private System.Windows.Forms.RadioButton rdoAllPatients;
		private System.Windows.Forms.RadioButton rdoIndividualReport;
		private System.Windows.Forms.Label lblPatientName;
		private System.Windows.Forms.TextBox txtPatientName;
		private System.Windows.Forms.Button btnSelectPatient;
		private System.Windows.Forms.TextBox txtPatientID;
		private System.Windows.Forms.Label lblPatientID;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgTransfusionEffectivenessReportCriteria()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._report = new BOL.TransfusionEffectivenessReport();
			this._report.Valid += new System.EventHandler(this.CheckValid);
			this._report.Invalid += new System.EventHandler(this.CheckValid);
			this._report.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this._report.SetInitialBrokenRules(this.Name);

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgTransfusionEffectivenessReportCriteria));
			this.grpReportType = new System.Windows.Forms.GroupBox();
			this.rdoAllPatients = new System.Windows.Forms.RadioButton();
			this.rdoIndividualReport = new System.Windows.Forms.RadioButton();
			this.grpPatient = new System.Windows.Forms.GroupBox();
			this.txtPatientID = new System.Windows.Forms.TextBox();
			this.lblPatientID = new System.Windows.Forms.Label();
			this.btnSelectPatient = new System.Windows.Forms.Button();
			this.txtPatientName = new System.Windows.Forms.TextBox();
			this.lblPatientName = new System.Windows.Forms.Label();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpReportType.SuspendLayout();
			this.grpPatient.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Transfusion Effectiveness Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 353);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpReportType
			// 
			this.grpReportType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportType.Controls.Add(this.rdoAllPatients);
			this.grpReportType.Controls.Add(this.rdoIndividualReport);
			this.grpReportType.Controls.Add(this.grpPatient);
			this.grpReportType.Location = new System.Drawing.Point(60, 88);
			this.grpReportType.Name = "grpReportType";
			this.grpReportType.Size = new System.Drawing.Size(328, 120);
			this.grpReportType.TabIndex = 1;
			this.grpReportType.TabStop = false;
			this.grpReportType.Text = "Report Type*";
			// 
			// rdoAllPatients
			// 
			this.rdoAllPatients.Checked = true;
			this.rdoAllPatients.Location = new System.Drawing.Point(12, 16);
			this.rdoAllPatients.Name = "rdoAllPatients";
			this.rdoAllPatients.Size = new System.Drawing.Size(148, 20);
			this.rdoAllPatients.TabIndex = 0;
			this.rdoAllPatients.TabStop = true;
			this.rdoAllPatients.Text = "&All Patients";
			this.rdoAllPatients.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// rdoIndividualReport
			// 
			this.rdoIndividualReport.Location = new System.Drawing.Point(12, 36);
			this.rdoIndividualReport.Name = "rdoIndividualReport";
			this.rdoIndividualReport.Size = new System.Drawing.Size(156, 20);
			this.rdoIndividualReport.TabIndex = 1;
			this.rdoIndividualReport.Text = "&Individual Patient Report";
			this.rdoIndividualReport.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// grpPatient
			// 
			this.grpPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatient.Controls.Add(this.txtPatientID);
			this.grpPatient.Controls.Add(this.lblPatientID);
			this.grpPatient.Controls.Add(this.btnSelectPatient);
			this.grpPatient.Controls.Add(this.txtPatientName);
			this.grpPatient.Controls.Add(this.lblPatientName);
			this.grpPatient.Enabled = false;
			this.grpPatient.Location = new System.Drawing.Point(8, 39);
			this.grpPatient.Name = "grpPatient";
			this.grpPatient.Size = new System.Drawing.Size(312, 72);
			this.grpPatient.TabIndex = 2;
			this.grpPatient.TabStop = false;
			// 
			// txtPatientID
			// 
			this.txtPatientID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientID.Location = new System.Drawing.Point(92, 44);
			this.txtPatientID.Name = "txtPatientID";
			this.txtPatientID.ReadOnly = true;
			this.txtPatientID.Size = new System.Drawing.Size(192, 20);
			this.txtPatientID.TabIndex = 4;
			this.txtPatientID.TabStop = false;
			this.txtPatientID.Text = "";
			// 
			// lblPatientID
			// 
			this.lblPatientID.Location = new System.Drawing.Point(20, 44);
			this.lblPatientID.Name = "lblPatientID";
			this.lblPatientID.Size = new System.Drawing.Size(80, 20);
			this.lblPatientID.TabIndex = 3;
			this.lblPatientID.Text = "Patient ID*";
			this.lblPatientID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSelectPatient
			// 
			this.btnSelectPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectPatient.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSelectPatient.Location = new System.Drawing.Point(284, 20);
			this.btnSelectPatient.Name = "btnSelectPatient";
			this.btnSelectPatient.Size = new System.Drawing.Size(24, 20);
			this.btnSelectPatient.TabIndex = 2;
			this.btnSelectPatient.Text = "find";
			this.btnSelectPatient.Click += new System.EventHandler(this.PatientSearch);
			// 
			// txtPatientName
			// 
			this.txtPatientName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientName.Location = new System.Drawing.Point(92, 20);
			this.txtPatientName.Name = "txtPatientName";
			this.txtPatientName.ReadOnly = true;
			this.txtPatientName.Size = new System.Drawing.Size(192, 20);
			this.txtPatientName.TabIndex = 1;
			this.txtPatientName.TabStop = false;
			this.txtPatientName.Text = "";
			// 
			// lblPatientName
			// 
			this.lblPatientName.Location = new System.Drawing.Point(20, 20);
			this.lblPatientName.Name = "lblPatientName";
			this.lblPatientName.Size = new System.Drawing.Size(80, 20);
			this.lblPatientName.TabIndex = 0;
			this.lblPatientName.Text = "Patient Name*";
			this.lblPatientName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(328, 52);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(224, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2100, 1, 1, 23, 59, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.EndDateChanged);
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(172, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(1900, 1, 1, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.StartDateChanged);
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 212);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(328, 120);
			this.grpReportCompilation.TabIndex = 2;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(312, 72);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.MaxLength = 50;
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(196, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.PrinterNameChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(196, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.PrintDateChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(232, 336);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.ClickOK);
			this.btnOK.MouseHover += new System.EventHandler(this.HoverOK);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(312, 336);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.ClickCancel);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 300);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// DlgTransfusionEffectivenessReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 369);
			this.Controls.Add(this.grpReportType);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpDateRange);
			this.hlphelpChm.SetHelpKeyword(this, "Transfusion_Effectiveness_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 396);
			this.Name = "DlgTransfusionEffectivenessReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Transfusion Effectiveness Report";
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.Controls.SetChildIndex(this.grpReportType, 0);
			this.grpReportType.ResumeLayout(false);
			this.grpPatient.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC091.DlgTransfusionEffectivenessReportCriteria());
			//
			this.btnOK.Text = "&OK";
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			//BR_77.01
			this.dtpStartDate.Value = this._report.StartDate;
			this.dtpEndDate.Value = this._report.EndDate;
			this.dtpPrintDate.Value = currentDate;
			//
			LoadPrinters();
		}

		/// <summary>
		/// Gets report object
		/// </summary>
		public BOL.TransfusionEffectivenessReport TransfusionEffectivenessReport
		{
			get
			{
				return this._report;
			}
		}

		private void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		private void ReportCompilationChanged(object sender, System.EventArgs e)
		{
			this._report.IsScheduled = (this.rdoScheduleJob.Checked);
			this.grpScheduleJob.Enabled = (this.rdoScheduleJob.Checked);
			if ((this._report.IsScheduled) && (this._report.PrintDate == DateTime.MinValue))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}
		}

		private void ClickOK(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if (this._report.IsScheduledReportGreaterThanThirtyDays)
				{
					if (DialogResult.Yes != GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays()))
					{
						return;
					}
				}
				//
				try
				{
					this._report.Schedule();
					//
					this.DialogResult = DialogResult.Cancel;
				}
				catch(BOL.BusinessObjectException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.ScheduleReportFailed());
					return;
				}
			}
			else
			{
				int count = 0;
				//
				BOL.LabTest labTest = new BOL.LabTest();
				labTest.ReportType = Common.ReportType.TransfusionEffectiveness;
				System.Data.DataRow[] labTests = labTest.GetLabTests().Select(Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode+" = '"+Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active)+"'");
				//
				if (labTests.Length>0)
				{
					if (this._report.IsAllPatients)
					{
						count = BOL.PatientTransfusion.GetTransfusedUnitsInDateRangeCount(this._report.StartDate, this._report.EndDate);
					}
					else
					{
						count = BOL.PatientTransfusion.GetTransfusedUnitsInDateRangeCount(this._report.StartDate, this._report.EndDate, this._report.Patient.PatientGuid);
					}
				}
				//
				if(count==0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
					return;
				}
				else if(count>=50)
				{
					DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
					if( _result != DialogResult.Yes )
					{
						return;
					}
					else
					{
						//Alert user that building report may take a few minutes
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
					}
				}
				//
				this.DialogResult = DialogResult.OK;
			}
			this.Close();
		}

		private void ClickCancel(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void PrintDateChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				this._report.PrintDate = this.dtpPrintDate.Value;
			}
			//
			this.CheckDates();
		}

		private void PrinterNameChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if(cmbPrinterName.SelectedItem!=null)
				{
					string printer=this.cmbPrinterName.Text;
					for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
					{
						if(printer==this.cmbPrinterName.Items[i].ToString())
						{
							this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
						}
					}
				}		
				else
				{
					this._report.PrinterName=String.Empty;
				}
			}
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this._report.IsValid);
		}

		private void CheckDates()
		{
			if (this._report.StartDate > this._report.EndDate)
			{
				this.errError.SetVbecsError(this.dtpEndDate, Common.StrRes.SysErrMsg.Common.CannotbeGreaterError("Start date","End date").ResString); // **** 508 Compliance ***
			}
			else
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); // **** 508 Compliance ***
			}
			//
			if (this._report.IsScheduled)
			{
				if (this._report.EndDate > this._report.PrintDate)
				{
					this.errError.SetVbecsError(this.dtpPrintDate, Common.StrRes.SysErrMsg.Common.CannotbeLessError("Print date","End date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
				}
			}
			else
			{
				this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
			}
		}

		private void StartDateChanged(object sender, System.EventArgs e)
		{
			this._report.StartDate = this.dtpStartDate.Value;
			//
			this.CheckDates();
		}

		private void EndDateChanged(object sender, System.EventArgs e)
		{
			this._report.EndDate = this.dtpEndDate.Value;
			//
			this.CheckDates();
		}

		private void HoverOK(object sender, System.EventArgs e)
		{
			if (this._report.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this._report.GetBrokenRulesMessage(this.Name));
			}
		}

		private void PatientSearch(object sender, System.EventArgs e)
		{
			FrmPatientSelect dlg = new FrmPatientSelect(false);
			if (dlg.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
			this._report.Patient = dlg.SelectedPatient;
			this.txtPatientName.Text = this._report.Patient.DisplayName;
			this.txtPatientID.Text = this._report.Patient.DisplayPatientID;
		}

		private void ReportTypeChanged(object sender, System.EventArgs e)
		{
			this._report.IsAllPatients = this.rdoAllPatients.Checked;
			this.grpPatient.Enabled = (!this._report.IsAllPatients);
		}

	}
}

